/*
    Руская православная элементарная система единства периодичности электроатомов Вселенной.
    (с) 1997, Рыбников Юрий Степанович.

    Автор программы: (с) 2014, Добуланс Андрей <rellder@outlook.com>
    Версия программы: 1.5
*/

// GLOBALS
var WRAP = document.getElementById('wrap_3d'),
WIDTH = WRAP.offsetWidth,
HEIGHT = WRAP.offsetHeight,
RENDERER, SCENE, CAMERA, CONTROLS;

// DATA
var S,
R = 128, // bazovij razmer vseroda
N = 0, // period (2^N)
C = 0; // cislo elektroatomov v periode

// DATA
var PERIOD = ['Всерод', 'Первород', 'Двурод', 'Трирод', 'Четырерод', 'Пятирод', 'Шестирод', 'Семирод'];
var COLORS = [
create_material(0x777777),
create_material(0xCC33FF),
create_material(0x33CCFF),
create_material(0x33FFCC),
create_material(0xF92672),
create_material(0xFFCC33),
create_material(0xCC33FF),
create_material(0x33CCFF),
create_material(0xFF6633),
];

// VSEROD OBJECT
var Vserod = function(r, s) {
	this.radius = r;
	this.scale = s;
};

Vserod.prototype.create = function(geometry, material) {
	var a, aa, aaa;
	this.mesh = new THREE.Mesh(geometry, material);
	this.mesh.position.x = this.radius - R;
	this.mesh.rotation.z = Math.PI / 2;
	if (this.scale) { a = aa = aaa = this.scale; }
	else { a = aa = aaa = 1; }
	this.mesh.scale.set(a, S == 3 ? 0.01 : aa, S == 2 ? 0.01 : aaa);
	SCENE.add(this.mesh);
}

function create_geometry(size) {
	return new THREE.SphereGeometry(size, 32, 16);
}

function create_material(color) {
	return new THREE.MeshBasicMaterial({
	wireframe: S == 1 ? false : true,
	transparent: true,
	opacity: 0.1,
	color: color || 0xFF0000,
	depthWrite: false,
	side: THREE.BackSide,
	blending: S == 1 ? THREE.NormalBlending : THREE.AdditiveBlending
	});
}

// DISPLAY
function DISPLAY_INFO() {
	var element = document.getElementById('atom_info');
	var html = '';
	var n = Math.pow(2, N);
	var atom = DATABASE[C + ';' + n] || {};
	if (!C && n == 1) n = 0;
	html += '<span class="l">Название:</span> <i>';
	if(atom['name'] || atom['rus']) {
	html += (atom['name'] || '') + ' (РУС-' + atom['rus'] + ')';
	} else {
	html += '&mdash;';
	}
	html += '</i><br>';
	html += '<span class="l">Тип:</span> <i>' + (atom['type'] || '&mdash;') + '</i><br>';
	html += '<span class="l">Маркировка:</span> <i>' + (atom['element'] || '&mdash;') + '</i><br>';
	html += '<span class="l">Верхний индекс:</span> <i>' + C + '</i><br>';
	html += '<span class="l">Нижний индекс:</span> <i>' + n + '</i><br>';
	html += '<span class="l">Род атома:</span> <i>' + PERIOD[N] + '</i>';        
	element.innerHTML = html;
}

function CLEAR_DISPLAY_INFO() {
   atom_info.innerHTML = '';
}

// RENDER
function INIT() {
	// Scene
	SCENE = new THREE.Scene();
	CAMERA = new THREE.PerspectiveCamera(32, WIDTH / HEIGHT, 0.1, 4096);
	CONTROLS = new THREE.OrbitControls(CAMERA,WRAP);
	RENDERER = new THREE.WebGLRenderer({antialias: true});
	// Rederer
	RENDERER.setSize(WIDTH, HEIGHT);
	RENDERER.setClearColor(0x00000, 1);
	WRAP.appendChild(RENDERER.domElement);
	// Camera
	CAMERA.position.z = 548;
	SCENE.add(CAMERA);
	// Init objects
	INIT_OBJECTS();
}

function RENDER() {
	requestAnimationFrame(RENDER);
	RENDERER.render(SCENE, CAMERA);
	CONTROLS.update();
}

// SCENE OBJECTS

function INIT_OBJECTS() {
	var vserod, geometry, material,	atoms, radius, scale, half;
	if(SCENE&&SCENE.children.length){
		while(SCENE.children.length>0){
			SCENE.remove(SCENE.children[SCENE.children.length-1]);
		}
	}
	for (var n = 0; n <= N; n++) {
		atoms = Math.pow(2, n); // kolicestvo elektroatomov v periode
		radius = R / atoms; // razmer elektroatoma v periode
		if (N > 7) {
			CLEAR_DISPLAY_INFO();
			alert('Слишком большая степень!');
			break;
		}
		// poslednij period
		if (n == N) {
			if (C > atoms || (N == 0 && C !== 0)) {
				CLEAR_DISPLAY_INFO();
				alert('Недопустимое количество электроатомов на последней линии проводимости!');
				break;
			}
			atoms = C;
		}
		if (C == 0 && n !== 0) atoms = 2; // 0 kolonka
		// poslednij period, esli atomi ne cetnije
		if (n == N && atoms % 2) {
			atoms += 1;
			half = true;
		}
		geometry = create_geometry(radius);
		// prisvaivajem cvet
		if (C == 0) {
			if (n == 0) {
				material = COLORS[0];
			}else{
				material = COLORS[n];
			}
		}else{
			material = COLORS[n + 1];
		}
		// pervorod
		if (N == 0 && C == 0) {
			vserod = new Vserod(R);
			vserod.create(geometry, material);
		};
		for (var i = 0; i < atoms; i++) {
			// 1/2 necetnogo atoma
			if (half && (i == 0 || i == atoms-1)) {
				scale = 0.5;
				position = radius / 2 + i * (radius - radius / (C * 2)) * 2 + radius - atoms * radius;
			} else {
				scale = false;
				position = i * radius * 2 + radius - atoms * radius;
			}
			vserod = new Vserod(position + R, scale);
			vserod.create(geometry, material);
		}
	}
}

function PRE_INIT(hash) {
	// HASH
	if(!hash)hash = window.location.hash.substring(1);
	if (hash) {
		hash = hash.split(';');
		N = parseInt(hash[0]);
		C = parseInt(hash[1]);
		if (hash.length == 3) {
			if (hash[2].indexOf('0') >= 0) { S = 0; }
			else if (hash[2].indexOf('1') >= 0) { S = 1; }
			else if (hash[2].indexOf('2') >= 0) { S = 2; }
			else if (hash[2].indexOf('3') >= 0) { S = 3; }
		}
	}
	RENDERER.clear();
	DISPLAY_INFO();
	INIT_OBJECTS();
}
// START
DISPLAY_INFO();
INIT();
RENDER();